/*
 * hmc5883.c
 *
 *  Created on: Apr 18, 2015
 *      Author: Jordan
 */

#include "config.h"
#include "i2c.h"
#include "hmc5883.h"
#include "gio.h"
#include "hmc5883.h"

#define HMC5883_ADDR 0x1E

float32 flux_x, flux_y, flux_z;

uint32 timeout;

void hmc5883_init(){
	hmc5883_write(0, 0x78);
	hmc5883_write(2, 0);
}

void hmc5883_update(){
	uint8 data[6];
	hmc5883_read_array(0x03, 6, data);

	flux_x = (float32)(sint16)(data[0]<<8 | data[1])/FLUX_DIV;
	flux_z = (float32)(sint16)(data[2]<<8 | data[3])/FLUX_DIV;
	flux_y = (float32)(sint16)(data[4]<<8 | data[5])/FLUX_DIV;
}

float32 hmc5883_get_mag(char axis){
	float32 flux;
	switch(axis){
		case 'x': flux = -flux_y; break;
		case 'y': flux = flux_x; break;
		case 'z': flux = flux_z; break;
	}
	return flux;
}

void hmc5883_write(uint8 addr, uint8 data){
	uint8 tx[2] = {addr, data};
	i2cSetSlaveAdd(i2cREG1, HMC5883_ADDR);
	i2cSetDirection(i2cREG1, I2C_TRANSMITTER);
	i2cSetCount(i2cREG1, 2);
	i2cSetMode(i2cREG1, I2C_MASTER);
	i2cSetStop(i2cREG1);
	i2cSetStart(i2cREG1);
	hmc5883_send(i2cREG1, 2, tx);
	hmc5883_wait();
	i2cClearSCD(i2cREG1);
	delay_ms(.001);
}

void hmc5883_read_array(uint8 addr, uint32 size, uint8* data){
	i2cSetSlaveAdd(i2cREG1, HMC5883_ADDR);
	i2cSetDirection(i2cREG1, I2C_TRANSMITTER);
	i2cSetCount(i2cREG1, 1);
	i2cSetMode(i2cREG1, I2C_MASTER);
	i2cSetStop(i2cREG1);
	i2cSetStart(i2cREG1);
	hmc5883_send(i2cREG1, 1, &addr);
	hmc5883_wait();
	i2cClearSCD(i2cREG1);
	delay_ms(0.01);

	i2cSetSlaveAdd(i2cREG1, HMC5883_ADDR);
	i2cSetDirection(i2cREG1, I2C_RECEIVER);
	i2cSetCount(i2cREG1, size);
	i2cSetMode(i2cREG1, I2C_MASTER);
	i2cSetStop(i2cREG1);
	i2cSetStart(i2cREG1);
	hmc5883_receive(i2cREG1, size, data);
	hmc5883_wait();
	i2cClearSCD(i2cREG1);
	delay_ms(0.01);
}

void hmc5883_wait(){
	timeout = 0;
	while(i2cIsBusBusy(i2cREG1) == true && timeout++ < 3000);
	while(i2cIsStopDetected(i2cREG1) == 0 && timeout++ < 3000);
}

void hmc5883_send(i2cBASE_t *i2c, uint32 length, uint8 * data)
{
	/* send the data */
	while (length > 0U)
	{
		timeout = 0;

		/*SAFETYMCUSW 28 D MR:NA <APPROVED> "Potentially infinite loop found - Hardware Status check for execution sequence" */
		while ((i2c->STR & (uint32)I2C_TX_INT) == 0U && timeout++ < 3000)
		{
		} /* Wait */
		/*SAFETYMCUSW 45 D MR:21.1 <APPROVED> "Valid non NULL input parameters are only allowed in this driver" */
		i2c->DXR = (uint32)(*data);
		/*SAFETYMCUSW 45 D MR:21.1 <APPROVED> "Valid non NULL input parameters are only allowed in this driver" */
		/*SAFETYMCUSW 567 S MR:17.1,17.4 <APPROVED> "Pointer increment needed" */
		data++;
		length--;
	}
}

void hmc5883_receive(i2cBASE_t *i2c, uint32 length, uint8 * data)
{
	while (length > 0U)
	{
		timeout = 0;

		/*SAFETYMCUSW 28 D MR:NA <APPROVED> "Potentially infinite loop found - Hardware Status check for execution sequence" */
		while ((i2c->STR & (uint32)I2C_RX_INT) == 0U && timeout++ < 3000)
		{
		} /* Wait */
		/*SAFETYMCUSW 45 D MR:21.1 <APPROVED> "Valid non NULL input parameters are only allowed in this driver" */
		*data = ((uint8)i2c->DRR);
		/*SAFETYMCUSW 45 D MR:21.1 <APPROVED> "Valid non NULL input parameters are only allowed in this driver" */
		/*SAFETYMCUSW 567 S MR:17.1,17.4 <APPROVED> "Pointer increment needed" */
		data++;
		length--;
	}
}
